/*****************************************************************************
*  LPC15xx RC5 decoder demoprogram for MicroCore100 rev A board
*
*  1. Use SCT2 timer to capture and decode RC5 messages.
*  2. Use USART0 to print received RC5 frames to PC terminal
*****************************************************************************/
#include "LPC15xx.h"
#include "global.h"

int main (void) 
{
    LPC_SYSCON->SYSAHBCLKCTRL0 |= (1 << 11);       // enable the PMUX clock
    LPC_PMUX->SCT2_P_MUX0 = 1;                     // SCT2_IN0 at P0_27

    USART0_Init(19200);
    RC5_Init();

    PrintString("\f\nLPC15xx SCT-RC5 test January 2014\n\n");

    while (1)
    {
        if (RC5_flag)                              // wait for RC5 code
        {
            RC5_flag = 0;                          // clear flag
            PrintString("RC5 = ");                 // and print it
            PrintByte(RC5_System);
            PrintString(" ");
            PrintByte(RC5_Command);
            PrintString("\n");
        }
    }
}
